/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VisitorDataView
extends CitizenDataView
implements IVisitorViewData {
    private final IColonyView colony;
    private ItemStack recruitmentCosts;
    private UUID textureUUID;
    private volatile ResourceLocation cachedTexture;

    public VisitorDataView(int id, IColonyView colony) {
        super(id);
        this.colony = colony;
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.recruitmentCosts = buf.m_130267_();
        this.recruitmentCosts.m_41764_(buf.readInt());
        if (buf.readBoolean()) {
            this.textureUUID = buf.m_130259_();
        }
    }

    @Override
    public IColonyView getColonyView() {
        return this.colony;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitmentCosts;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        if (this.textureUUID == null) {
            return null;
        }
        if (this.cachedTexture == null) {
            this.cachedTexture = DefaultPlayerSkin.m_118627_((UUID)this.textureUUID);
            Util.m_183991_().execute(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                GameProfile profile = new GameProfile(this.textureUUID, "mcoltexturequery");
                minecraft.m_91108_().fillProfileProperties(profile, true);
                Map map = minecraft.m_91109_().m_118815_(profile);
                if (!map.isEmpty()) {
                    this.cachedTexture = minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
            });
        }
        return this.cachedTexture;
    }
}

